/*	ahruman-vector-test.js
	JavaScript test.oxp
	
	Script to test all methods (and behind-the-scene fuctions) of Vector class.
	
	NOTE: doesn’t test rotateBy yet.
*/
this.name			= "JavaScript vector test";
this.author			= "Jens Ayton";
this.copyright		= "This work is hereby placed in the public domain.";
this.description	= "A test of vector functionality in Oolite.";
this.version		= "1.0";


this.startUp = function()
{
	LogWithClass("jsvectortest.didLaunch", "Exercising vectors.");
	var x = new Vector(1, 0, 0);	// Constructor with numbers
	var y = new Vector(0, 1, 0);
	var z = new Vector(0, 0, 1);
	
	var copy = new Vector(x);		// Constructor with vector
	copy.x = 0;						// SetProperty, altering a copy without affecting original
	copy.y = y.y;					// GetProperty
	
	LogWithClass("jsvectortest.test", "x - 2y: [expect: (1, -2, 0)]: " + x.subtract(y.multiply(2)));
	LogWithClass("jsvectortest.test", "Copied vector [expect: (0, 1, 0)]: " + copy);
	LogWithClass("jsvectortest.test", "copy == x [expect: false]: " + (copy == x));		// comparison to nonequal
	LogWithClass("jsvectortest.test", "copy == y [expect: true]: " + (copy == y));		// comparison to equal
	
	var nullVector = new Vector;	// Constructor with no arguments, should give (0, 0, 0)
	LogWithClass("jsvectortest.test", "Null constructor [expect: (0, 0, 0)]: " + nullVector);
	
	
	LogWithClass("jsvectortest.test", "|x + y| · x [expect: cos 45° = 1/√2]: " + x.add(y).direction().dot(x));
	
	LogWithClass("jsvectortest.test", "x × y [expect: (0, 0, 1)]: " + x.cross(y));
	
	LogWithClass("jsvectortest.test", "x.distanceTo(y) [expect: √2]: " + x.distanceTo(y));
	LogWithClass("jsvectortest.test", "x.squaredDistanceTo(y) [expect: 2]: " + x.squaredDistanceTo(y));
	LogWithClass("jsvectortest.test", "x.angleTo(y) [expect: π/2]: " + x.angleTo(y));
	LogWithClass("jsvectortest.test", "x.tripleProduct(y, 2, 3, 4) [expect: 4]: " + x.tripleProduct(y, 2, 3, 4));
	LogWithClass("jsvectortest.test", "(x + y).direction() [expect: (1/√2, 1/√2, 0)]: " + x.add(y).direction());
	LogWithClass("jsvectortest.test", "|x + y| [expect: √2]: " + x.add(y).magnitude());
	LogWithClass("jsvectortest.test", "|x + y| [expect: 2]: " + x.add(y).squaredMagnitude());
	LogWithClass("jsvectortest.test", "x.rotationTo(y): " + x.rotationTo(y));
	LogWithClass("jsvectortest.test", "x.rotationTo(y, 1): " + x.rotationTo(y, 1));	// Rotation with limited arc (effectively slerp)
}
